;;; - ------------------------------------------------------------------------------ - ;
;;; -                 T O O L - K_RC-AUTO                                            - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Beschreibung :  nderungswolken Automat                                        - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Befehle      :  k_rc-auto                                                      - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - letzte nderung am : 21.06.2023                                                - ;
;;; -              durch : Andreas Kraus                                             - ;
;;; - ------------------------------------------------------------------------------ - ;

(vl-load-com)
(DEFUN COMPARE (E0 E1 /)
  (COND	((> (CAR E0) (CAR E1)) 1)
	((< (CAR E0) (CAR E1)) -1)
	((QUOTE T) 0)
  )
)
(DEFUN GATHER (LST LEN)
  (COND	((NULL LST) nil)
	((> (LENGTH LST) LEN)
	 (CONS (N-CAR LEN LST) (GATHER (N-CDR LEN LST) LEN))
	)
	((QUOTE SONST) (LIST LST))
  )
)
(DEFUN I-CDR (LST) (REVERSE (CDR (REVERSE LST))))
(DEFUN K_->ENT_NAME (NAME)
  (COND	((= (TYPE NAME) (QUOTE ENAME)) NAME)
	((= (TYPE NAME) (QUOTE VLA-OBJECT))
	 (vlax-vla-object->ename NAME)
	)
	((= (TYPE NAME) (QUOTE STR)) (HANDENT NAME))
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC -1 NAME))
	 (CDR (ASSOC -1 NAME))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC 5 NAME))
	 (HANDENT (CDR (ASSOC 5 NAME)))
	)
  )
)
(DEFUN K_->OBJ_NAME (NAME)
  (COND	((= (TYPE NAME) (QUOTE ENAME))
	 (vlax-ename->vla-object NAME)
	)
	((= (TYPE NAME) (QUOTE VLA-OBJECT)) NAME)
	((= (TYPE NAME) (QUOTE STR))
	 (vlax-ename->vla-object (HANDENT NAME))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC -1 NAME))
	 (vlax-ename->vla-object (CDR (ASSOC -1 NAME)))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC 5 NAME))
	 (vlax-ename->vla-object (HANDENT (CDR (ASSOC 5 NAME))))
	)
  )
)
(DEFUN K_AC-DOC	nil
  (vla-get-ActiveDocument (vlax-get-acad-object))
)
(DEFUN K_AC-LAYOUT (FILE)
  (IF FILE
    (vla-get-ActiveLayout FILE)
    (vla-get-ActiveLayout (K_AC-DOC))
  )
)
(DEFUN K_ACBC (DUMMY1 DUMMY2)
  (IF (VL-STRING-SEARCH "BricsCAD" (GETVAR "acadver"))
    DUMMY1
    DUMMY2
  )
)
(DEFUN K_ADDREGION (OBJ_LIST)
  (IF (= (TYPE (SETQ DUMMY (VL-CATCH-ALL-APPLY
			     (QUOTE vla-AddRegion)
			     (LIST (vla-get-Block (K_AC-LAYOUT nil))
				   (vlax-safearray-fill
				     (vlax-make-safearray
				       vlax-vbObject
				       (CONS 0 (1- (LENGTH OBJ_LIST)))
				     )
				     OBJ_LIST
				   )
			     )
			   )
	       )
	 )
	 (QUOTE variant)
      )
    (K_VARIANT->VALUE DUMMY)
  )
)
(DEFUN K_AP_ANDERS (L0 L1 / CMP L2)
  (WHILE (AND L0 L1)
    (SETQ CMP (K_AP_COMPARE
		(CDR (ASSOC 5 (CAR L0)))
		(CDR (ASSOC 5 (CAR L1)))
	      )
    )
    (COND ((= CMP -1) (SETQ L0 (CDR L0)))
	  ((= CMP 1) (SETQ L1 (CDR L1)))
	  ((QUOTE T)
	   (SETQ L2 (CONS (CAR L0) L2)
		 L0 (CDR L0)
		 L1 (CDR L1)
	   )
	  )
    )
  )
  L2
)
(DEFUN K_AP_COMPARE (E0 E1 /)
  (COND	((> E0 E1) 1)
	((< E0 E1) -1)
	((QUOTE T) 0)
  )
)
(DEFUN K_AP_ENTLIST nil
  (MAPCAR (QUOTE (LAMBDA (OBJ_NAME / ENT_NAME OBJ PROP)
		   (K_SORT_ENT_DATA (K_GET_ENT_DATA OBJ_NAME))
		 )
	  )
	  (K_COLLECTION->LIST (vla-get-ModelSpace (K_AC-DOC)))
  )
)
(defun k_ap_entlist_getbb (ent_list / minp maxp)
  (mapcar '(lambda (data)
	     (if (vl-catch-all-error-p
		   (vl-catch-all-apply
		     'vla-getboundingbox
		     (list (k_->obj_name data)
			   'minp
			   'maxp
		     )
		   )
		 )
	       (cond
		 ((assoc 15 data)
		  (setq	minp (cdr (assoc 15 data))
			maxp (cdr (assoc 15 data))
		  )
		 )
		 ((assoc 14 data)
		  (setq	minp (cdr (assoc 14 data))
			maxp (cdr (assoc 14 data))
		  )
		 )
		 ((assoc 13 data)
		  (setq	minp (cdr (assoc 13 data))
			maxp (cdr (assoc 13 data))
		  )
		 )
		 ((assoc 12 data)
		  (setq	minp (cdr (assoc 12 data))
			maxp (cdr (assoc 12 data))
		  )
		 )
		 ((assoc 11 data)
		  (setq	minp (cdr (assoc 11 data))
			maxp (cdr (assoc 11 data))
		  )
		 )
		 ((assoc 10 data)
		  (setq	minp (cdr (assoc 10 data))
			maxp (cdr (assoc 10 data))
		  )
		 )
		 (t
		  (setq	minp '(0 0 0)
			maxp '(0 0 0)
		  )
		 )
	       )
	     )
	     (append data
		     (list (list "bbox"
				 (cond
				   ((= (type minp) 'safearray)
				    (vlax-safearray->list minp)
				   )
				   ((= (type minp) 'variant)
				    (k_variant->value minp)
				   )
				   ((= (type minp) 'list)
				    minp
				   )
				 )
				 (cond
				   ((= (type maxp) 'safearray)
				    (vlax-safearray->list maxp)
				   )
				   ((= (type maxp) 'variant)
				    (k_variant->value maxp)
				   )
				   ((= (type maxp) 'list)
				    maxp
				   )
				 )
			   )
		     )
	     )
	   )
	  ent_list
  )
)
(DEFUN K_AP_ENTLIST_PURGE (ENT_LIST)
  (MAPCAR (QUOTE
	    (LAMBDA (ENT_DATA)
	      (VL-REMOVE-IF
		(QUOTE (LAMBDA (DATA) (= (TYPE (CDR DATA)) (QUOTE ENAME))))
		(COND ((MEMBER (CDR (ASSOC 0 ENT_DATA))
			       (QUOTE ("DIMENSION" "ARC_DIMENSION"))
		       )
		       (K_DEL_ASSOC ENT_DATA (QUOTE (11 10 70)))
		      )
		      ((MEMBER (CDR (ASSOC 0 ENT_DATA))
			       (QUOTE ("LARGE_RADIAL_DIMENSION"))
		       )
		       (K_DEL_ASSOC ENT_DATA (QUOTE (11 10 13 14 70)))
		      )
		      (T ENT_DATA)
		)
	      )
	    )
	  )
	  (VL-REMOVE-IF
	    (QUOTE
	      (LAMBDA (DATA)
		(AND (=	(vla-get-ObjectName (K_->OBJ_NAME DATA))
			"AcDbBlockReference"
		     )
		     (K_IS (vla-get-IsXRef (K_GET-DEF (K_->OBJ_NAME DATA) nil)))
		)
	      )
	    )
	    ENT_LIST
	  )
  )
)
(DEFUN K_AP_LSCH-NEU (L0 L1 / CMP L2)
  (WHILE (AND L0 L1)
    (SETQ CMP (K_AP_COMPARE
		(CDR (ASSOC 5 (CAR L0)))
		(CDR (ASSOC 5 (CAR L1)))
	      )
    )
    (COND ((= CMP -1)
	   (SETQ L2 (CONS (CAR L0) L2)
		 L0 (CDR L0)
	   )
	  )
	  ((= CMP 1) (SETQ L1 (CDR L1)))
	  ((QUOTE T)
	   (SETQ L0 (CDR L0)
		 L1 (CDR L1)
	   )
	  )
    )
  )
  (APPEND L2 L0)
)
(DEFUN K_BIT (WERT BIT) (= (LOGAND WERT BIT) BIT))
(DEFUN K_COLLECTION->LIST (COLLECTION / LISTE)
  (COND	((MEMBER "VLA-COLLECTION->LIST" (ATOMS-FAMILY 1))
	 (SETQ LISTE (VLA-COLLECTION->LIST COLLECTION))
	)
	((MEMBER "VLAX-FOR" (ATOMS-FAMILY 1))
	 (SETQ LISTE (LIST))
	 (VLAX-FOR DUMMY COLLECTION (SETQ LISTE (CONS DUMMY LISTE)))
	 (REVERSE LISTE)
	)
  )
  LISTE
)
(DEFUN K_COLOR->POPERTY	(COLOR)
  (COND	((= (STRCASE COLOR) "VONLAYER") "256")
	((= (STRCASE COLOR) "BYLAYER") "256")
	((= (STRCASE COLOR) "VONBLOCK") "0")
	((= (STRCASE COLOR) "BYLAYER") "0")
	(T COLOR)
  )
)
(DEFUN K_COUNTER_DIALOG	(TODO TXT1 TXT2)
  (DEFUN K_COUNTER_DIALOG_NEU nil
    (DONE_DIALOG)
    (NEW_DIALOG "k_counter_dialog" K_COUNTER_DLG)
    (SETQ K_COUNTER_DIALOG_N 0)
  )
  (COND	((AND (= (TYPE TODO) (QUOTE STR)) (= (STRCASE TODO) "START"))
	 (SETQ K_COUNTER_DLG
				      (LOAD_DIALOG "k_rc-auto.dcl")
	       K_COUNTER_DIALOG_N     0
	       K_COUNTER_DIALOG_TITEL TXT1
	 )
	 (COND ((AND TXT2 (= (TYPE TXT1) (QUOTE INT)))
		(SETQ K_COUNTER_DIALOG_X TXT2)
	       )
	       ((AND TXT2 (= (TYPE TXT1) (QUOTE STR)))
		(SETQ K_COUNTER_DIALOG_T TXT2)
	       )
	       (T (SETQ K_COUNTER_DIALOG_X nil))
	 )
	 (IF (NOT (NEW_DIALOG "k_counter_dialog" K_COUNTER_DLG))
	   (EXIT)
	 )
	 (IF K_COUNTER_DIALOG_TITEL
	   (SET_TILE "titel"
		     (VL-PRINC-TO-STRING K_COUNTER_DIALOG_TITEL)
	   )
	 )
	)
	((AND (= (TYPE TODO) (QUOTE STR)) (= (STRCASE TODO) "END"))
	 (DONE_DIALOG)
	 (IF K_COUNTER_DLG
	   (UNLOAD_DIALOG K_COUNTER_DLG)
	 )
	 (SETQ K_COUNTER_DIALOG_N nil
	       K_COUNTER_DLG	  nil
	 )
	)
	((AND (= (TYPE TODO) (QUOTE STR)) (= (STRCASE TODO) "SHOW"))
	 (SETQ K_COUNTER_DIALOG_N (1+ K_COUNTER_DIALOG_N))
	 (IF (AND K_COUNTER_DIALOG_X
		  (>= K_COUNTER_DIALOG_N K_COUNTER_DIALOG_X)
	     )
	   (K_COUNTER_DIALOG_NEU)
	 )
	 (SET_TILE "text1" (VL-PRINC-TO-STRING TXT1))
	 (SET_TILE "text2" (VL-PRINC-TO-STRING TXT2))
	)
	(T nil)
  )
)
(DEFUN K_DEL-NTH (LISTE N / DUMMY_LIST)
  (REPEAT N
    (SETQ DUMMY_LIST (CONS (CAR LISTE) DUMMY_LIST)
	  LISTE	     (CDR LISTE)
    )
  )
  (APPEND (REVERSE DUMMY_LIST) (CDR LISTE))
)
(DEFUN K_DEL_ASSOC (LISTE GRUPPE)
  (IF (/= (TYPE GRUPPE) (QUOTE LIST))
    (SETQ GRUPPE (LIST GRUPPE))
  )
  (VL-REMOVE-IF
    (QUOTE (LAMBDA (DATA) (MEMBER (CAR DATA) GRUPPE)))
    LISTE
  )
)
(DEFUN K_ELLIPSE->PLINE	(OBJ_NAME BREITE / D L N OBJ_LIST OBJ_NAME P P1	P2 P3 PREC P_LIST Q Z)
  (SETQ	PREC	 64
	OBJ_NAME (K_->OBJ_NAME OBJ_NAME)
	L	 (IF (K_IS-CLOSED OBJ_NAME)
		   (* (vlax-curve-getDistAtPoint
			OBJ_NAME
			(vlax-curve-getPointAtParam OBJ_NAME PI)
		      )
		      2.0
		   )
		   (vlax-curve-getDistAtPoint
		     OBJ_NAME
		     (vlax-curve-getEndPoint OBJ_NAME)
		   )
		 )
	N	 (* PREC
		    (/ (ABS (- (vlax-curve-getEndParam OBJ_NAME)
			       (vlax-curve-getStartParam OBJ_NAME)
			    )
		       )
		       (* PI 2.0)
		    )
		 )
  )
  (IF (NOT (EQUAL (REM N 1) 0))
    (SETQ N (1+ (FIX N)))
  )
  (SETQ	P_LIST (MAPCAR (QUOTE (LAMBDA (P) (TRANS P 0 1)))
		       (MAPCAR (QUOTE (LAMBDA (D) (vlax-curve-getPointAtDist OBJ_NAME D)))
			       (K_ZAHLENREIHE_START_STEP N 0 (/ L N))
		       )
	       )
  )
  (SETQ	P_LIST	 (MAPCAR (QUOTE	(LAMBDA	(P)
				  (MAPCAR (QUOTE (LAMBDA (Q) (ROUND Q 1.0e-08))) P)
				)
			 )
			 P_LIST
		 )
	OBJ_LIST (MAPCAR (QUOTE
			   (LAMBDA (P1 P3 / P2 Z)
			     (SETQ P2 (TRANS (vlax-curve-getPointAtParam
					       OBJ_NAME
					       (/ (+ (vlax-curve-getParamAtPoint OBJ_NAME (TRANS P1 1 0))
						     (IF (EQUAL	(vlax-curve-getParamAtPoint OBJ_NAME (TRANS P3 1 0))
								0
							 )
						       (* PI 2.0)
						       (vlax-curve-getParamAtPoint OBJ_NAME (TRANS P3 1 0))
						     )
						  )
						  2.0
					       )
					     )
					     0
					     1
				      )
			     )
			     (SETQ Z (INTERS (K_MIDP P1 P2)
					     (POLAR (K_MIDP P1 P2) (+ (ANGLE P1 P2) (* PI 0.5)) 1)
					     (K_MIDP P2 P3)
					     (POLAR (K_MIDP P2 P3) (+ (ANGLE P2 P3) (* PI 0.5)) 1)
					     nil
				     )
			     )
			     (vla-AddArc
			       (vla-get-Block (vla-get-ActiveLayout (K_AC-DOC)))
			       (vlax-3d-point (TRANS Z 1 0))
			       (DISTANCE Z P1)
			       (ANGLE Z P1)
			       (ANGLE Z P3)
			     )
			   )
			 )
			 (I-CDR P_LIST)
			 (CDR P_LIST)
		 )
  )
  (vla-Delete OBJ_NAME)
  (CAR (K_SATZ->OBJLIST (P001 OBJ_LIST BREITE)))
)
(DEFUN K_ENTLIST->SATZ (ENT_LIST / N SATZ ENT_NAME)
  (IF (LISTP ENT_LIST)
    (PROGN (SETQ SATZ (SSADD))
	   (MAPCAR (QUOTE
		     (LAMBDA (ENT_NAME)
		       (COND ((= (TYPE ENT_NAME) (QUOTE VLA-OBJECT))
			      (SETQ SATZ (SSADD (vlax-vla-object->ename ENT_NAME) SATZ))
			     )
			     ((= (TYPE ENT_NAME) (QUOTE ENAME))
			      (SETQ SATZ (SSADD ENT_NAME SATZ))
			     )
			     ((= (TYPE ENT_NAME) (QUOTE STR))
			      (IF (HANDENT ENT_NAME)
				(SETQ SATZ (SSADD (HANDENT ENT_NAME) SATZ))
			      )
			     )
		       )
		     )
		   )
		   ENT_LIST
	   )
    )
  )
  SATZ
)
(DEFUN K_FILTER	(OBJ_LIST FILTER_LIST)
  (IF (NOT (LISTP (CAR FILTER_LIST)))
    (SETQ FILTER_LIST (LIST FILTER_LIST))
  )
  (FOREACH FILTER FILTER_LIST
    (SETQ OBJ_LIST (VL-REMOVE-IF-NOT
		     (QUOTE
		       (LAMBDA (OBJ)
			 (IF (VL-CATCH-ALL-ERROR-P
			       (SETQ DUMMY (VL-CATCH-ALL-APPLY
					     (QUOTE EVAL)
					     (LIST
					       (LIST (READ (STRCAT "vla-get-" (VL-PRINC-TO-STRING (CAR FILTER))))
						     OBJ
					       )
					     )
					   )
			       )
			     )
			   nil
			   (EQUAL (K_VARIANT->VALUE
				    (EVAL
				      (LIST (READ (STRCAT "vla-get-" (VL-PRINC-TO-STRING (CAR FILTER))))
					    OBJ
				      )
				    )
				  )
				  (CADR FILTER)
			   )
			 )
		       )
		     )
		     OBJ_LIST
		   )
    )
  )
  OBJ_LIST
)
(DEFUN K_GET-DEF (OBJ_NAME FILE)
  (IF (NULL FILE)
    (SETQ FILE (K_AC-DOC))
  )
  (SETQ OBJ_NAME (K_->OBJ_NAME OBJ_NAME))
  (COND	((= (vla-get-ObjectName OBJ_NAME) "AcDbBlockReference")
	 (vla-Item (vla-get-Blocks FILE) (vla-get-Name OBJ_NAME))
	)
	((= (vla-get-ObjectName OBJ_NAME) "AcDbAttribute")
	 (CAR
	   (K_FILTER (K_COLLECTION->LIST
		       (vla-Item (vla-get-Blocks FILE)
				 (CDR
				   (ASSOC 2
					  (ENTGET (CDR (ASSOC 330 (ENTGET (K_->ENT_NAME OBJ_NAME)))))
				   )
				 )
		       )
		     )
		     (LIST "tagstring" (vla-get-TagString OBJ_NAME))
	   )
	 )
	)
	((= (vla-get-ObjectName OBJ_NAME) "AcDbMline")
	 (vla-Item (vla-Item (vla-get-Dictionaries FILE) "acad_mlinestyle")
		   (vla-get-StyleName OBJ_NAME)
	 )
	)
	(T nil)
  )
)
(DEFUN K_GET-TEXTSTRING	(ENT_NAME / ENT_DATA)
  (SETQ	ENT_DATA (COND ((= (TYPE ENT_NAME) (QUOTE VLA-OBJECT))
			(ENTGET (vlax-vla-object->ename ENT_NAME))
		       )
		       ((= (TYPE ENT_NAME) (QUOTE ENAME)) (ENTGET ENT_NAME))
		       ((= (TYPE ENT_NAME) (QUOTE LIST)) ENT_NAME)
		 )
  )
  (WHILE (> (LENGTH (K_GET_ASSOC ENT_DATA 1)) 1)
    (SETQ ENT_DATA (K_DEL-NTH ENT_DATA
			      (VL-POSITION (ASSOC 1 ENT_DATA) ENT_DATA)
		   )
    )
  )
  (COND	((= (CDR (ASSOC 0 ENT_DATA)) "ATTDEF")
	 (APPLY	(QUOTE STRCAT)
		(MAPCAR (QUOTE CDR) (K_GET_ASSOC ENT_DATA (QUOTE (1 3))))
	 )
	)
	((MEMBER (CDR (ASSOC 0 ENT_DATA))
		 (QUOTE ("TEXT" "MTEXT" "ATTRIB"))
	 )
	 (APPLY	(QUOTE STRCAT)
		(MAPCAR (QUOTE CDR) (K_GET_ASSOC ENT_DATA (QUOTE (1 3))))
	 )
	)
	((MEMBER (CDR (ASSOC 0 ENT_DATA)) (QUOTE ("MULTILEADER")))
	 (vla-get-TextString
	   (vlax-ename->vla-object (CDR (ASSOC -1 ENT_DATA)))
	 )
	)
	(T nil)
  )
)
(DEFUN K_GET_ASSOC (LISTE GRUPPE)
  (IF (/= (TYPE GRUPPE) (QUOTE LIST))
    (SETQ GRUPPE (LIST GRUPPE))
  )
  (VL-REMOVE-IF-NOT
    (QUOTE (LAMBDA (DATA) (MEMBER (CAR DATA) GRUPPE)))
    LISTE
  )
)
(DEFUN K_GET_ENT_DATA (ENT_NAME)
  (SETQ ENT_NAME (K_->ENT_NAME ENT_NAME))
  (SETQ OBJ_NAME (K_->OBJ_NAME ENT_NAME))
  (APPLY (QUOTE APPEND)
	 (LIST (ENTGET ENT_NAME)
	       (APPLY (QUOTE APPEND) (K_GET_SUBOBJ ENT_NAME))
	       (IF (AND	(vlax-property-available-p OBJ_NAME "hasattributes")
			(= (vla-get-HasAttributes OBJ_NAME) :vlax-true)
			(NOT
			  (MINUSP (vlax-safearray-get-u-bound
				    (vlax-variant-value (vla-GetAttributes OBJ_NAME))
				    1
				  )
			  )
			)
		   )
		 (MAPCAR (QUOTE
			   (LAMBDA (OBJ)
			     (LIST (vla-get-TagString OBJ) (K_GET-TEXTSTRING OBJ))
			   )
			 )
			 (vlax-invoke OBJ_NAME (QUOTE GETATTRIBUTES))
		 )
	       )
	       (IF (AND	(vlax-property-available-p OBJ_NAME "isdynamicblock")
			(= (vla-get-IsDynamicBlock OBJ_NAME) :vlax-true)
		   )
		 (VL-REMOVE (QUOTE nil)
			    (MAPCAR (QUOTE (LAMBDA (PROP)
					     (IF (= (vla-get-Show PROP) :vlax-true)
					       (LIST (vla-get-PropertyName PROP)
						     (vlax-variant-value (vla-get-Value PROP))
					       )
					     )
					   )
				    )
				    (IF	(VL-CATCH-ALL-ERROR-P
					  (VL-CATCH-ALL-APPLY
					    (QUOTE vlax-invoke)
					    (LIST OBJ_NAME (QUOTE GETDYNAMICBLOCKPROPERTIES))
					  )
					)
				      nil
				      (vlax-invoke OBJ_NAME (QUOTE GETDYNAMICBLOCKPROPERTIES))
				    )
			    )
		 )
	       )
	 )
  )
)
(DEFUN K_GET_MERKLISTE (NAME / WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ WERT (NTH 1 (ASSOC NAME K_MERKLISTE)))
  )
  WERT
)
(DEFUN K_GET_SUBOBJ (ENT_NAME / DATA_LIST)
  (COND	((AND (= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "POLYLINE")
	      (= (CDR (ASSOC 66 (ENTGET ENT_NAME))) 1)
	 )
	 (SETQ ENT_NAME (ENTNEXT ENT_NAME))
	 (WHILE	(/= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "SEQEND")
	   (SETQ DATA_LIST (CONS (ENTGET ENT_NAME) DATA_LIST))
	   (SETQ ENT_NAME (ENTNEXT ENT_NAME))
	 )
	)
  )
  (REVERSE DATA_LIST)
)
(DEFUN K_INTERSECT (ENT1 ENT2 EXTEND / AR)
  (SETQ ENT1 (K_->OBJ_NAME ENT1))
  (SETQ ENT2 (K_->OBJ_NAME ENT2))
  (COND	((= EXTEND 0)
	 (SETQ AR (vlax-invoke-method
		    ENT1
		    (QUOTE INTERSECTWITH)
		    ENT2
		    acExtendNone
		  )
	 )
	)
	((= EXTEND 1)
	 (SETQ AR (vlax-invoke-method
		    ENT1
		    (QUOTE INTERSECTWITH)
		    ENT2
		    acExtendThisEntity
		  )
	 )
	)
	((= EXTEND 2)
	 (SETQ AR (vlax-invoke-method
		    ENT1
		    (QUOTE INTERSECTWITH)
		    ENT2
		    acExtendOtherEntity
		  )
	 )
	)
	((= EXTEND 3)
	 (SETQ AR (vlax-invoke-method
		    ENT1
		    (QUOTE INTERSECTWITH)
		    ENT2
		    acExtendBoth
		  )
	 )
	)
  )
  (IF (/= -1
	  (vlax-safearray-get-u-bound (vlax-variant-value AR) 1)
      )
    (GATHER (vlax-safearray->list (vlax-variant-value AR)) 3)
  )
)
(DEFUN K_IS (WERT)
  (COND	((= WERT :vlax-false) nil)
	((= WERT :vlax-true) T)
	((= WERT nil) nil)
	((= WERT T) T)
	((= WERT 1) T)
	((= WERT 0) nil)
	((= WERT "1") T)
	((= WERT "0") nil)
	((= (STRCASE WERT) "JA") T)
	((= (STRCASE WERT) "NEIN") nil)
  )
)
(DEFUN K_IS-CLOSED (OBJ_NAME)
  (SETQ OBJ_NAME (K_->OBJ_NAME OBJ_NAME))
  (COND	((MEMBER (vla-get-ObjectName OBJ_NAME)
		 (QUOTE ("AcDbPolyline" "AcDb3dPolyline" "AcDbSpline"))
	 )
	 (K_IS (vla-get-Closed OBJ_NAME))
	)
	((= (vla-get-ObjectName OBJ_NAME) "AcDbMline")
	 (K_BIT (CDR (ASSOC 71 ENT_DATA)) 2)
	)
	((= (vla-get-ObjectName OBJ_NAME) "AcDbEllipse")
	 (AND (/= (vla-get-StartAngle OBJ_NAME)
		  (vla-get-EndAngle OBJ_NAME)
	      )
	      (EQUAL (POLAR (QUOTE (0.0 0.0 0.0))
			    (vla-get-StartAngle OBJ_NAME)
			    1.0
		     )
		     (POLAR (QUOTE (0.0 0.0 0.0))
			    (vla-get-EndAngle OBJ_NAME)
			    1.0
		     )
		     1.0e-08
	      )
	 )
	)
  )
)
(DEFUN K_LISTE->VARIANT	(LISTE TYP)
  (vlax-make-variant
    (vlax-safearray-fill
      (vlax-make-safearray 5 (CONS 0 (1- (LENGTH LISTE))))
      LISTE
    )
    TYP
  )
)
(DEFUN K_MEM_LAYSTAT (/ LAYSTATLIST LAY)
  (SETQ	LAYSTATLIST
	 (MAPCAR (QUOTE	(LAMBDA	(LAY)
			  (LIST	(vla-get-Name LAY)
				(vla-get-LayerOn LAY)
				(vla-get-Freeze LAY)
				(vla-get-Lock LAY)
			  )
			)
		 )
		 (K_COLLECTION->LIST (vla-get-Layers (K_AC-DOC)))
	 )
  )
  (K_PUT_MERKLISTE
    "k_mem_laystat"
    (VL-REMOVE (QUOTE nil)
	       (CONS LAYSTATLIST (K_GET_MERKLISTE "k_mem_laystat"))
    )
  )
  (PRINC)
)
(DEFUN K_MIDP (P1 P2)
  (SETQ MIDP (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) P1 P2))
)
(DEFUN K_OBJLIST->SATZ (OBJ_LIST)
  (K_ENTLIST->SATZ
    (MAPCAR (QUOTE vlax-vla-object->ename) OBJ_LIST)
  )
)
(DEFUN K_PUT_MERKLISTE (NAME WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ K_MERKLISTE
	   (SUBST (LIST NAME WERT)
		  (ASSOC NAME K_MERKLISTE)
		  K_MERKLISTE
	   )
    )
    (SETQ K_MERKLISTE (CONS (LIST NAME WERT) K_MERKLISTE))
  )
  (PRINC)
)
(DEFUN K_RESTORE_VAR (VARLIST / K_SAVEVAR_LIST)
  (SETQ K_SAVEVAR_LIST (K_GET_MERKLISTE "k_savevar_list"))
  (IF (= VARLIST "*")
    (SETQ VARLIST (MAPCAR (QUOTE (LAMBDA (VAR) (NTH 0 VAR))) K_SAVEVAR_LIST))
  )
  (IF (= (TYPE VARLIST) (QUOTE STR))
    (SETQ VARLIST (LIST VARLIST))
  )
  (FOREACH VAR VARLIST
    (IF	(SETQ VAR (ASSOC VAR K_SAVEVAR_LIST))
      (SETVAR (NTH 0 VAR) (NTH 1 VAR))
    )
  )
)
(DEFUN K_RP_MAKE_ENT_DATA_LIST nil
  (K_COUNTER_DIALOG
    "start"
    (STRCAT (ITOA (vla-get-Count (vla-get-ModelSpace (K_AC-DOC))))
	    " Objekte erfassen"
    )
    nil
  )
  (IF (NULL (SETQ ENT_DATA_LIST (K_AP_ENTLIST_GETBB (K_AP_ENTLIST_PURGE (K_AP_ENTLIST))))
      )
    (SETQ ENT_DATA_LIST "leer")
  )
  (vlax-ldata-put "k_rc-auto" "alt_data_list" ENT_DATA_LIST)
  (K_COUNTER_DIALOG "end" nil nil)
  ENT_DATA_LIST
)
(DEFUN K_RST_LAYSTAT (/ OBJ_NAME DAT)
  (SETVAR "cmdecho" 0)
  (FOREACH DAT (CAR (K_GET_MERKLISTE "k_mem_laystat"))
    (IF	(AND (TBLSEARCH "LAYER" (NTH 0 DAT))
	     (SETQ OBJ_NAME (vla-Item (vla-get-Layers (K_AC-DOC)) (NTH 0 DAT)))
	)
      (PROGN (vla-put-LayerOn OBJ_NAME (NTH 1 DAT))
	     (IF (/= (CAR DAT) (GETVAR "clayer"))
	       (vla-put-Freeze OBJ_NAME (NTH 2 DAT))
	     )
	     (vla-put-Lock OBJ_NAME (NTH 3 DAT))
      )
    )
  )
  (IF (CDR (K_GET_MERKLISTE "k_mem_laystat"))
    (K_PUT_MERKLISTE
      "k_mem_laystat"
      (CDR (K_GET_MERKLISTE "k_mem_laystat"))
    )
  )
  (PRINC)
)
(DEFUN K_SATZ->ENTLIST (SATZ)
  (IF (= (TYPE SATZ) (QUOTE PICKSET))
    (VL-REMOVE-IF-NOT
      (QUOTE (LAMBDA (DUMMY) (= (TYPE DUMMY) (QUOTE ENAME))))
      (MAPCAR (QUOTE CADR) (SSNAMEX SATZ))
    )
  )
)
(DEFUN K_SATZ->OBJLIST (SATZ)
  (MAPCAR (QUOTE vlax-ename->vla-object)
	  (K_SATZ->ENTLIST SATZ)
  )
)
(DEFUN K_SAVE_VAR (VARLIST / K_SAVEVAR_LIST)
  (SETQ K_SAVEVAR_LIST (K_GET_MERKLISTE "k_savevar_list"))
  (IF (= (TYPE VARLIST) (QUOTE STR))
    (SETQ VARLIST (LIST VARLIST))
  )
  (FOREACH VAR VARLIST
    (IF	(ASSOC VAR K_SAVEVAR_LIST)
      (SETQ K_SAVEVAR_LIST
	     (SUBST (LIST VAR (GETVAR VAR))
		    (ASSOC VAR K_SAVEVAR_LIST)
		    K_SAVEVAR_LIST
	     )
      )
      (SETQ K_SAVEVAR_LIST (CONS (LIST VAR (GETVAR VAR)) K_SAVEVAR_LIST))
    )
  )
  (K_PUT_MERKLISTE "k_savevar_list" K_SAVEVAR_LIST)
)
(DEFUN K_SORT_ENT_DATA (ENT_DATA)
  (VL-SORT ENT_DATA
	   (QUOTE (LAMBDA (Q1 Q2)
		    (< (VL-PRINC-TO-STRING (CAR Q1))
		       (VL-PRINC-TO-STRING (CAR Q2))
		    )
		  )
	   )
  )
)
(DEFUN K_VARIANT->VALUE	(VAR / VALUE)
  (IF (= (TYPE VAR) (QUOTE variant))
    (PROGN (SETQ VALUE (vlax-variant-value VAR))
	   (COND ((= (TYPE VALUE) (QUOTE safearray))
		  (IF (MINUSP (vlax-safearray-get-u-bound VALUE 1))
		    nil
		    (vlax-safearray->list VALUE)
		  )
		 )
		 (T VALUE)
	   )
    )
    VAR
  )
)
(DEFUN K_ZAHLENREIHE (Z / N REIHE)
  (SETQ REIHE (LIST Z))
  (REPEAT (FIX Z) (SETQ REIHE (CONS (1- (CAR REIHE)) REIHE)))
  REIHE
)
(DEFUN K_ZAHLENREIHE_START (Z START)
  (MAPCAR (QUOTE (LAMBDA (N) (+ START N))) (K_ZAHLENREIHE Z))
)
(DEFUN K_ZAHLENREIHE_START_STEP	(Z START STEP)
  (MAPCAR (QUOTE (LAMBDA (N) (+ START (* STEP N))))
	  (K_ZAHLENREIHE_START Z 0)
  )
)
(DEFUN L-2NDINHIBITION (L0 L1 / CMP L2)
  (SETQ L0 (VL-SORT (MAKE-SORTABLE L0) (QUOTE _<)))
  (SETQ L1 (VL-SORT (MAKE-SORTABLE L1) (QUOTE _<)))
  (WHILE (AND L0 L1)
    (SETQ CMP (COMPARE (CAR L0) (CAR L1)))
    (COND ((= CMP -1)
	   (SETQ L2 (CONS (CDAR L0) L2)
		 L0 (CDR L0)
	   )
	  )
	  ((= CMP 1) (SETQ L1 (CDR L1)))
	  ((QUOTE T)
	   (SETQ L0 (CDR L0)
		 L1 (CDR L1)
	   )
	  )
    )
  )
  (APPEND L2 (MAPCAR (QUOTE CDR) L0))
)
(DEFUN MAKE-SORTABLE (L /)
  (MAPCAR (QUOTE (LAMBDA (E /) (CONS (VL-PRIN1-TO-STRING E) E)))
	  L
  )
)
(DEFUN N-CAR (N LST / RES)
  (REPEAT (MIN N (LENGTH LST))
    (SETQ RES (CONS (CAR LST) RES)
	  LST (CDR LST)
    )
  )
  (REVERSE RES)
)
(DEFUN N-CDR (N LST) (REPEAT N (SETQ LST (CDR LST))))
(DEFUN P001 (SATZ BREITE / PLINE_SATZ ANZAHL N RCKGABE	ENT_NAME NEW_ARC OBJ)
  (IF (COND ((= (TYPE SATZ) (QUOTE PICKSET)) SATZ)
	    ((= (TYPE SATZ) (QUOTE LIST))
	     (SETQ SATZ (K_ENTLIST->SATZ SATZ))
	    )
	    ((= (TYPE SATZ) (QUOTE ENAME))
	     (SETQ SATZ (K_ENTLIST->SATZ (LIST SATZ)))
	    )
	    ((= (TYPE SATZ) (QUOTE VLA-OBJECT))
	     (SETQ SATZ (K_ENTLIST->SATZ (LIST SATZ)))
	    )
	    (T nil)
      )
    (PROGN (SETQ PLINE_SATZ (SSADD))
	   (FOREACH ENT_NAME (K_SATZ->ENTLIST SATZ)
	     (COND ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "LWPOLYLINE")
		    (SETQ PLINE_SATZ (SSADD ENT_NAME PLINE_SATZ))
		   )
		   ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "SPLINE")
		    (K_SAVE_VAR "DELOBJ")
		    (SETVAR "DELOBJ" (K_ACBC 3 2))
		    (COMMAND "_.SPLINEDIT" ENT_NAME "_p" "")
		    (K_RESTORE_VAR "DELOBJ")
		    (SETQ PLINE_SATZ (SSADD (ENTLAST) PLINE_SATZ))
		   )
		   ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "ELLIPSE")
		    (SETQ PLINE_SATZ
			   (SSADD (K_->ENT_NAME (K_ELLIPSE->PLINE ENT_NAME BREITE))
				  PLINE_SATZ
			   )
		    )
		   )
		   ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "REGION")
		    (P001 (K_VARIANT->VALUE (vla-Explode (K_->OBJ_NAME ENT_NAME)))
			  BREITE
		    )
		    (vla-Delete (K_->OBJ_NAME ENT_NAME))
		   )
		   ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "HATCH")
		    (COMMAND "_.explode" ENT_NAME)
		    (P001 (K_SATZ->OBJLIST (SSGET "_p")) BREITE)
		   )
		   ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "CIRCLE")
		    (SETQ OBJ (K_->OBJ_NAME ENT_NAME))
		    (SETQ NEW_ARC (vla-AddArc
				    (vla-get-Block (vla-get-ActiveLayout (K_AC-DOC)))
				    (vla-get-Center OBJ)
				    (vla-get-Radius OBJ)
				    0
				    PI
				  )
		    )
		    (COMMAND "_.pedit"
			     (K_->ENT_NAME NEW_ARC)
			     "_y"
			     "_w"
			     BREITE
			     "x"
		    )
		    (SETQ PLINE_SATZ (SSADD (ENTLAST) PLINE_SATZ))
		    (SETQ NEW_ARC (vla-AddArc
				    (vla-get-Block (vla-get-ActiveLayout (K_AC-DOC)))
				    (vla-get-Center OBJ)
				    (vla-get-Radius OBJ)
				    PI
				    (* PI 2.0)
				  )
		    )
		    (COMMAND "_.pedit"
			     (K_->ENT_NAME NEW_ARC)
			     "_y"
			     "_w"
			     BREITE
			     "x"
		    )
		    (SETQ PLINE_SATZ (SSADD (ENTLAST) PLINE_SATZ))
		    (vla-Delete OBJ)
		   )
		   (T
		    (COMMAND "_.pedit" ENT_NAME "_y" "_w" BREITE "x")
		    (SETQ PLINE_SATZ (SSADD (ENTLAST) PLINE_SATZ))
		   )
	     )
	   )
	   (SETQ PLINE_SATZ
		  (K_OBJLIST->SATZ
		    (VL-REMOVE-IF
		      (QUOTE (LAMBDA (OBJ) (K_IS (vla-get-Closed OBJ))))
		      (K_SATZ->OBJLIST PLINE_SATZ)
		    )
		  )
	   )
	   (SETQ ANZAHL (SSLENGTH PLINE_SATZ))
	   (SETQ N 0)
	   (REPEAT ANZAHL
	     (IF PLINE_SATZ
	       (PROGN (SETQ ENT_NAME (SSNAME PLINE_SATZ N))
		      (COMMAND "_.pedit" ENT_NAME "_j" PLINE_SATZ "")
		      (WHILE (/= (GETVAR "cmdactive") 0) (COMMAND "x"))
		      (SETQ RCKGABE (CONS ENT_NAME RCKGABE))
		      (SETQ PLINE_SATZ (SSGET "_p"))
		      (IF PLINE_SATZ
			(IF (= ANZAHL (SSLENGTH PLINE_SATZ))
			  (SETQ N (1+ N))
			  (SETQ N 0)
			)
		      )
	       )
	     )
	   )
    )
  )
  (SETVAR "cmdecho" 0)
  (K_ENTLIST->SATZ RCKGABE)
)
(DEFUN RAD (Z) (* (/ Z 180.0) PI))
(DEFUN ROUND (NUM PREC)
  (IF (ZEROP PREC)
    NUM
    (IF	(MEMBER (TYPE NUM) (QUOTE (INT REAL)))
      (* PREC
	 (FIX (IF (MINUSP NUM)
		(- (/ NUM PREC) 0.5)
		(+ (/ NUM PREC) 0.5)
	      )
	 )
      )
      NUM
    )
  )
)
(DEFUN TAN (Z) (/ (SIN Z) (COS Z)))
(DEFUN _< (E0 E1 /) (< (CAR E0) (CAR E1)))

(defun c:k_rc-auto (/		  ABSTAND	ALT_DATA_LIST ANDERS-LSCH_LIST		  ANDERS-NEU_LIST	      ANDERS_LIST   C		  DATA
		    DUMMY	  DUMMY_LIST	FEHLER_LIST   FRAGE	    GRP5_LST	  LSCH_LIST	MAXP	      MEM_LIST	    MINP	  NEU_DATA_LIST
		    NEU_LIST	  OBJ_LIST	PL-OBJECT     PL_LIST	    RC_SATZ	  REF_LIST	REGION_LIST   RG_NAME	    SATZ
		   )
;;;  Revisionswolken vollautomatisch erstellen
  (defun k_rc-auto_do (ent_data_list / dummy dummy_list)
;;; Liste mit Polygonen erstellen
    (setq
      pl_list (mapcar
		'(lambda (data)
		   (setq dummy	   (cdr (assoc "bbox" data))
			 minp	   (car dummy)
			 maxp	   (cadr dummy)
			 pl-object (vla-AddLightWeightPolyline
				     (vla-get-block (k_ac-layout nil))
				     (k_liste->variant
				       (list (- (car minp) abstand)
					     (- (cadr minp) abstand)
					     (- (car minp) abstand)
					     (+ (cadr maxp) abstand)
					     (+ (car maxp) abstand)
					     (+ (cadr maxp) abstand)
					     (+ (car maxp) abstand)
					     (- (cadr minp) abstand)
				       )
				       8197
				     )
				   )
		   )
		   (vla-put-closed pl-object :vlax-true)
		   pl-object
		 )
		ent_data_list
	      )
    )
    (setq mem_list pl_list)
;;; Regionen erstellen, verbinden, in Polylinien wandeln und Revisionswolken daraus erzeugen
    (while pl_list
      (setq ref_list (list (car pl_list))
	    pl_list  (cdr pl_list)
      )
      (while (setq dummy_list
		    (apply
		      'append
		      (mapcar '(lambda (obj)
				 (vl-remove-if-not
				   '(lambda (ref_obj) (k_intersect ref_obj obj 0))
				   pl_list
				 )
			       )
			      ref_list
		      )
		    )
	     )
	(setq ref_list (append ref_list dummy_list)
	      pl_list  (vl-remove-if
			 '(lambda (obj) (member obj ref_list))
			 pl_list
		       )
	)
      )
      (setq region_list (k_addregion ref_list))
      (vl-catch-all-apply
	'mapcar
	(list 'vla-delete ref_list)
      )
      (command "_union" (k_objlist->satz region_list) "")
      (setq
	obj_list (k_variant->value
		   (vla-explode (setq rg_name (k_->obj_name (entlast))))
		 )
      )
      (vla-delete rg_name)
      (setq rc_satz (p001 (k_objlist->satz obj_list) 0))
;;; Layer mit dem Textteil "nderungswolke" oer "Revcloud" suchen, sortieren und alphabetisch letzten verwenden
;;; dadurch wird der Layer mit dem neuesten nderungsindex verwendet
;;; es werden keine XREF-Layer bercksichtigt

      (if (vl-catch-all-error-p
	    (vl-catch-all-apply
	      'vl-cmdf
	      (list "_revcloud"
		    "_a"
		    (getvar "REVCLOUDMINARCLENGTH")
		    (getvar "REVCLOUDMAXARCLENGTH")
		    "_o"
		    (car (k_satz->entlist rc_satz))
		    "_n"
	      )
	    )
	  )
	(setq fehler_list (cons (car (k_satz->entlist rc_satz)) fehler_list))
      )
    )
    (mapcar 'vla-delete
	    (mapcar 'k_->obj_name
		    (vl-remove 'nil (mapcar 'k_->ent_name mem_list))
	    )
    )
  )

  (defun k_rc-auto_layer ()
    (if	(setq dummy (car
		      (vl-sort (vl-remove-if-not
				 '(lambda (lay)
				    (and (or (wcmatch (vla-get-description lay) "*nderungswolke*")
					     (wcmatch (vla-get-description lay) "*Revisionswolke*")
					     (wcmatch (vla-get-description lay) "*Revcloud*")
					 )
					 (/= (logand (cdr (assoc 70 (entget (k_->ent_name lay)))) 16)
					     16
					 )
				    )
				  )
				 (k_collection->list (vla-get-layers (k_ac-doc)))
			       )
			       '(lambda	(lay1 lay2)
				  (> (vla-get-description lay1) (vla-get-description lay2))
				)
		      )
		    )
	)
      (setvar "clayer" (vla-get-name dummy))
    )
  )

  (defun k_rc-auto_check_alt-neu ()
;;; alte und neue Objektdaten vergleichen und Datenlisten erstellen
    (setq anders-neu_list   (l-2ndinhibition
			      neu_data_list
			      (mapcar '(lambda (data) (k_del_assoc data "bbox"))
				      alt_data_list
			      )
			    )
	  anders-lsch_list (l-2ndinhibition
			      (mapcar '(lambda (data) (k_del_assoc data "bbox"))
				      alt_data_list
			      )
			      neu_data_list
			    )
	  grp5_lst	    (mapcar '(lambda (data) (cdr (assoc 5 data))) alt_data_list)
	  anders-lsch_list (mapcar '(lambda (data)
				       (if (vl-position (cdr (assoc 5 data)) grp5_lst)
					 (nth (vl-position (cdr (assoc 5 data)) grp5_lst)
					      alt_data_list
					 )
				       )
				     )
				    anders-lsch_list
			    )
	  anders-neu_list
			    (k_ap_entlist_getbb
			      (vl-sort anders-neu_list
				       '(lambda	(d1 d2)
					  (< (cdr (assoc 5 d1)) (cdr (assoc 5 d2)))
					)
			      )
			    )
	  anders-lsch_list
			    (vl-sort anders-lsch_list
				     '(lambda (d1 d2)
					(< (cdr (assoc 5 d1)) (cdr (assoc 5 d2)))
				      )
			    )
	  anders_list	    (k_ap_anders anders-neu_list anders-lsch_list)
	  lsch_list	    (k_ap_lsch-neu anders-lsch_list anders-neu_list)
	  neu_list	    (k_ap_lsch-neu anders-neu_list anders-lsch_list)
    )
  )

  (defun k_rc-auto_remove-rc (data_list)
    (vl-remove-if
      '(lambda (ent_data)
	 (and (= (cdr (assoc 0 ent_data)) "LWPOLYLINE")
	      (vl-every	'(lambda (bulge)
			   (equal (abs bulge) (tan (rad (/ 110.0 4.0))) 0.000001)
			 )
			(mapcar 'cdr (k_get_assoc ent_data 42))
	      )
	 )
       )
      data_list
    )
  )

  (vla-startundomark (k_ac-doc))
  (if (= (getvar "tilemode") 1)
    (progn
      (initget
	"Reset Entfernen Hinzufgen Markieren Zeichnen Objektwahl"
      )
      (setq frage (getkword
		    "[Reset/Entfernen/Hinzufgen/Markieren/Objektwahl/<Zeichnen>]: "
		  )
      )
      (if (null frage)
	(setq frage "Zeichnen")
      )
    )
    (progn
      (initget
	"Reset Objektwahl"
      )
      (setq frage (getkword
		    "[Reset/<Objektwahl>]: "
		  )
      )
      (if (null frage)
	(setq frage "Objektwahl")
      )
    )
  )

  (k_mem_laystat)
  (vlax-for lay	(vla-get-layers (k_ac-doc))
    (vla-put-lock lay :vlax-false)
  )
  (if (or (null (getvar "REVCLOUDAPPROXARCLEN"))
	  (equal (setq abstand (getvar "REVCLOUDAPPROXARCLEN")) 0)
      )
    (setq abstand
	   (abs	(/ (+ (getvar "REVCLOUDMINARCLENGTH")
		      (getvar "REVCLOUDMAXARCLENGTH")
		   )
		   2.0
		)
	   )
    )
  )
  (cond
    ((= frage "Reset")
     (k_rp_make_ent_data_list)
    )
    ((= frage "Entfernen")
     (setq dummy_list
	    (k_ap_entlist_getbb
	      (k_ap_entlist_purge
		(mapcar	'k_sort_ent_data
			(mapcar 'k_get_ent_data (k_satz->entlist (ssget)))
		)
	      )
	    )
     )
     (if (null (setq alt_data_list
		      (vlax-ldata-get
			"k_rc-auto"
			"alt_data_list"
		      )
	       )
	 )
       (setq alt_data_list (k_rp_make_ent_data_list))
     )
     (setq dummy_list
	    (mapcar '(lambda (dummy) (list (cdr (assoc 5 dummy)) dummy))
		    dummy_list
	    )
     )
     (setq alt_data_list
	    (mapcar '(lambda (data)
		       (if (setq dummy (assoc (cdr (assoc 5 data)) dummy_list))
			 (cadr dummy)
			 data
		       )
		     )
		    alt_data_list
	    )
     )
     (if (null alt_data_list)
       (setq alt_data_list "leer")
     )
     (vlax-ldata-put
       "k_rc-auto"
       "alt_data_list"
       alt_data_list
     )
    )
    ((= frage "Hinzufgen")
     (setq dummy_list
	    (k_ap_entlist_getbb
	      (k_ap_entlist_purge
		(mapcar	'k_sort_ent_data
			(mapcar 'k_get_ent_data (k_satz->entlist (ssget)))
		)
	      )
	    )
     )
     (if (null (setq alt_data_list
		      (vlax-ldata-get
			"k_rc-auto"
			"alt_data_list"
		      )
	       )
	 )
       (setq alt_data_list (k_rp_make_ent_data_list))
     )
     (setq dummy_list
	    (mapcar '(lambda (dummy)
		       (list (cdr (assoc 5 dummy)) (cons '("" "") dummy))
		     )
		    dummy_list
	    )
     )
     (setq alt_data_list
	    (mapcar '(lambda (data)
		       (if (setq dummy (assoc (cdr (assoc 5 data)) dummy_list))
			 (cadr dummy)
			 data
		       )
		     )
		    alt_data_list
	    )
     )
     (if (null alt_data_list)
       (setq alt_data_list "leer")
     )
     (vlax-ldata-put
       "k_rc-auto"
       "alt_data_list"
       alt_data_list
     )
    )
    ((= frage "Markieren")
     (setq alt_data_list
	    (vlax-ldata-get
	      "k_rc-auto"
	      "alt_data_list"
	    )
     )
     (if (= alt_data_list "leer")
       (setq alt_data_list nil)
     )
     (k_counter_dialog
       "start"
       (strcat (itoa (vla-get-count (vla-get-modelspace (k_ac-doc))))
	       " Objekte erfassen"
       )
       nil
     )
     (setq neu_data_list (k_ap_entlist_purge (k_ap_entlist)))
     (k_counter_dialog "end" nil nil)
     (if neu_data_list
       (progn
	 (k_counter_dialog
	   "start"
	   (strcat (itoa (vla-get-count (vla-get-modelspace (k_ac-doc))))
		   " Objekte vergleichen"
	   )
	   nil
	 )
	 (k_rc-auto_check_alt-neu)
	 (k_counter_dialog "end" nil nil)
	 (k_save_var "clayer")
	 (k_rc-auto_layer)
	 (setq c (atoi (k_color->poperty (getvar "cecolor"))))
	 (mapcar '(lambda (data)
		    (setq dummy	(cdr (assoc "bbox" data))
			  minp	(car dummy)
			  maxp	(cadr dummy)
		    )
		    (grvecs (list c
				  (list	(- (car minp) abstand)
					(- (cadr minp) abstand)
				  )
				  (list	(- (car minp) abstand)
					(+ (cadr maxp) abstand)
				  )
				  c
				  (list	(- (car minp) abstand)
					(+ (cadr maxp) abstand)
				  )
				  (list	(+ (car maxp) abstand)
					(+ (cadr maxp) abstand)
				  )
				  c
				  (list	(+ (car maxp) abstand)
					(+ (cadr maxp) abstand)
				  )
				  (list	(+ (car maxp) abstand)
					(- (cadr minp) abstand)
				  )
				  c
				  (list	(+ (car maxp) abstand)
					(- (cadr minp) abstand)
				  )
				  (list	(- (car minp) abstand)
					(- (cadr minp) abstand)
				  )
			    )
		    )
		  )
		 (k_rc-auto_remove-rc lsch_list)
	 )
	 (k_restore_var "clayer")
	 (setq satz (k_entlist->satz
		      (mapcar 'k_->ent_name
			      (k_rc-auto_remove-rc (append neu_list anders_list))
		      )
		    )
	 )
	 (command "_select" satz "")
	 (sssetfirst satz satz)
       )
       (vlax-ldata-put
	 "k_rc-auto"
	 "alt_data_list"
	 (setq alt_data_list "leer")
       )
     )
    )
    ((= frage "Zeichnen")
     (k_save_var '("cmdecho" "nomutt"))
     (setvar "cmdecho" 0)
     (setvar "nomutt" 1)
     (if (null (setq alt_data_list
		      (vlax-ldata-get
			"k_rc-auto"
			"alt_data_list"
		      )
	       )
	 )
       (setq alt_data_list (k_rp_make_ent_data_list))
     )
     (if (= alt_data_list "leer")
       (setq alt_data_list nil)
     )
     (k_counter_dialog
       "start"
       (strcat (itoa (vla-get-count (vla-get-modelspace (k_ac-doc))))
	       " Objekte erfassen"
       )
       nil
     )
     (setq neu_data_list (k_ap_entlist_purge (k_ap_entlist)))
     (k_counter_dialog "end" nil nil)
     (if neu_data_list
       (progn
	 (k_counter_dialog
	   "start"
	   (strcat (itoa (vla-get-count (vla-get-modelspace (k_ac-doc))))
		   " Objekte vergleichen"
	   )
	   nil
	 )
	 (k_rc-auto_check_alt-neu)
	 (k_counter_dialog "end" nil nil)
	 (vlax-ldata-put
	   "k_rc-auto"
	   "alt_data_list"
	   (k_ap_entlist_getbb neu_data_list)
	 )
	 (k_save_var "clayer")
	 (k_rc-auto_layer)

;;; Revisionswolken aus der Bearbeitung entfernen und Rest abarbeiten
	 (k_rc-auto_do
	   (k_rc-auto_remove-rc
	     (append neu_list anders_list lsch_list)
	   )
	 )
	 (k_restore_var "clayer")
       )
       (vlax-ldata-put
	 "k_rc-auto"
	 "alt_data_list"
	 (setq alt_data_list "leer")
       )
     )
     (k_restore_var '("cmdecho" "nomutt"))
    )
    ((= frage "Objektwahl")
     (k_save_var '("cmdecho" "nomutt"))
     (setvar "cmdecho" 0)
     (setvar "nomutt" 1)
     (k_rc-auto_do
       (setq dummy_list
	      (k_ap_entlist_getbb
		(k_ap_entlist_purge
		  (mapcar 'k_sort_ent_data
			  (mapcar 'k_get_ent_data (k_satz->entlist (ssget)))
		  )
		)
	      )
       )
     )
     (if (null (setq alt_data_list
		      (vlax-ldata-get
			"k_rc-auto"
			"alt_data_list"
		      )
	       )
	 )
       (setq alt_data_list (k_rp_make_ent_data_list))
     )
     (setq dummy_list
	    (mapcar '(lambda (dummy) (list (cdr (assoc 5 dummy)) dummy))
		    dummy_list
	    )
     )
     (setq alt_data_list
	    (mapcar '(lambda (data)
		       (if (setq dummy (assoc (cdr (assoc 5 data)) dummy_list))
			 (cadr dummy)
			 data
		       )
		     )
		    alt_data_list
	    )
     )
     (if (null alt_data_list)
       (setq alt_data_list "leer")
     )
     (vlax-ldata-put
       "k_rc-auto"
       "alt_data_list"
       alt_data_list
     )
    )
    (k_restore_var '("cmdecho" "nomutt"))
  )
  (k_rst_laystat)
  (vla-endundomark (k_ac-doc))
  (princ)
)

(if (null (vlax-ldata-get
	    "k_rc-auto"
	    "alt_data_list"
	  )
    )
  (k_rp_make_ent_data_list)
)
;;; - ------------------------------------------------------------------------------ - ;
(princ
  (strcat
    "\nk_rc-auto:  nderungswolken Automat"
    "\n===========  "
    "\n(C) Andreas Kraus 2023 (info@kraus-cad.de)"
    "\nBefehlszeilenaufruf : k_rc-auto\n"
  )
)
;;; - ------------------------------------------------------------------------------ - ;
(princ)
